/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Contract;

public class AttributeStateFacing
implements AttributeState {
    private final DirectionProperty facingProperty;
    private final FacePlacementType placementType;
    private final boolean canRotate;

    public AttributeStateFacing() {
        this(true);
    }

    public AttributeStateFacing(boolean canRotate) {
        this(BlockStateProperties.f_61374_, canRotate);
    }

    public AttributeStateFacing(DirectionProperty facingProperty) {
        this(facingProperty, true);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, boolean canRotate) {
        this(facingProperty, FacePlacementType.PLAYER_LOCATION, canRotate);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, FacePlacementType placementType) {
        this(facingProperty, placementType, true);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, FacePlacementType placementType, boolean canRotate) {
        this.facingProperty = facingProperty;
        this.placementType = placementType;
        this.canRotate = canRotate;
    }

    public boolean canRotate() {
        return this.canRotate;
    }

    public Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_((Property)this.getFacingProperty());
    }

    public BlockState setDirection(@Nonnull BlockState state, Direction newDirection) {
        return this.supportsDirection(newDirection) ? (BlockState)state.m_61124_((Property)this.getFacingProperty(), (Comparable)newDirection) : state;
    }

    @Nonnull
    public DirectionProperty getFacingProperty() {
        return this.facingProperty;
    }

    @Nonnull
    public FacePlacementType getPlacementType() {
        return this.placementType;
    }

    public Collection<Direction> getSupportedDirections() {
        return this.getFacingProperty().m_6908_();
    }

    public boolean supportsDirection(Direction direction) {
        return this.getSupportedDirections().contains(direction);
    }

    @Override
    public void fillBlockStateContainer(Block block, List<Property<?>> properties) {
        properties.add((Property<?>)this.getFacingProperty());
    }

    @Override
    public BlockState copyStateData(BlockState oldState, BlockState newState) {
        if (Attribute.has(newState, AttributeStateFacing.class)) {
            DirectionProperty oldFacingProperty = Attribute.get(oldState, AttributeStateFacing.class).getFacingProperty();
            newState = (BlockState)newState.m_61124_((Property)Attribute.get(newState, AttributeStateFacing.class).getFacingProperty(), (Comparable)((Direction)oldState.m_61143_((Property)oldFacingProperty)));
        }
        return newState;
    }

    @Override
    @Contract(value="_, null, _, _, _, _ -> null")
    public BlockState getStateForPlacement(Block block, @Nullable BlockState state, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nullable Player player, @Nonnull Direction face) {
        if (state == null) {
            return null;
        }
        AttributeStateFacing blockFacing = Attribute.get(block, AttributeStateFacing.class);
        Direction newDirection = Direction.SOUTH;
        if (blockFacing.getPlacementType() == FacePlacementType.PLAYER_LOCATION) {
            if (blockFacing.supportsDirection(Direction.DOWN) && blockFacing.supportsDirection(Direction.UP)) {
                float rotationPitch = player == null ? 0.0f : player.m_146909_();
                int height = Math.round(rotationPitch);
                if (height >= 65) {
                    newDirection = Direction.UP;
                } else if (height <= -65) {
                    newDirection = Direction.DOWN;
                }
            }
            if (newDirection != Direction.DOWN && newDirection != Direction.UP) {
                float placementYaw = player == null ? 0.0f : player.m_146908_();
                int side = Mth.m_14107_((double)((double)(placementYaw * 4.0f / 360.0f) + 0.5)) & 3;
                newDirection = switch (side) {
                    case 0 -> Direction.NORTH;
                    case 1 -> Direction.EAST;
                    case 2 -> Direction.SOUTH;
                    case 3 -> Direction.WEST;
                    default -> newDirection;
                };
            }
        } else {
            newDirection = blockFacing.supportsDirection(face) ? face : Direction.NORTH;
        }
        state = blockFacing.setDirection(state, newDirection);
        return state;
    }

    public static BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return AttributeStateFacing.rotate(state, rotation);
    }

    public static BlockState rotate(BlockState state, Rotation rotation) {
        AttributeStateFacing blockFacing;
        Block block = state.m_60734_();
        if (Attribute.has(block, AttributeStateFacing.class) && (blockFacing = Attribute.get(block, AttributeStateFacing.class)).canRotate()) {
            return AttributeStateFacing.rotate(blockFacing, blockFacing.getFacingProperty(), state, rotation);
        }
        return state;
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        AttributeStateFacing blockFacing;
        Block block = state.m_60734_();
        if (Attribute.has(block, AttributeStateFacing.class) && (blockFacing = Attribute.get(block, AttributeStateFacing.class)).canRotate()) {
            DirectionProperty property = blockFacing.getFacingProperty();
            return AttributeStateFacing.rotate(blockFacing, property, state, mirror.m_54846_((Direction)state.m_61143_((Property)property)));
        }
        return state;
    }

    private static BlockState rotate(AttributeStateFacing blockFacing, DirectionProperty property, BlockState state, Rotation rotation) {
        return blockFacing.setDirection(state, rotation.m_55954_((Direction)state.m_61143_((Property)property)));
    }

    public static enum FacePlacementType {
        PLAYER_LOCATION,
        SELECTED_FACE;

    }
}

